package ibase.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ibase.entity.Employee;
import ibase.entity.FeedbackCalendar;
import ibase.entity.Leave;
import ibase.entity.Holiday;
import ibase.entity.Plan;
import ibase.entity.Report;
import ibase.entity.TodaysPlan;
import ibase.utility.BaseLogger;

public class EmployeeDao {
	ResultSet rs = null;
	Statement stmt = null;
	Connection conn =null;
	public List<String> getEmployeeCodeName() {
		List<String> empCodeList = new ArrayList<String>();
		
		try {
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			String sql = "select emp_code,EMP_FNAME,EMP_MNAME,EMP_LNAME from employee start with report_to = '1515' connect by prior emp_code = report_to";
			BaseLogger.log("0",null,null,"getEmployeeCodeName sql="+sql);
			rs = stmt.executeQuery(sql);
			while (rs.next()) {
				
				empCodeList.add(rs.getString(1).trim()+" "+rs.getNString(2).trim()+" "+rs.getString(3).trim()+" "+rs.getString(4).trim());
			}
			BaseLogger.log("0",null,null,"getEmployeeCodeName()="+empCodeList);
		} catch (Exception e) {

		}
		finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return empCodeList;
	}
	
	public List<String> getEmployeeCodes() {
		
		List<String> empCodeList = new ArrayList<String>();
		try {
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			String sql = "select emp_code from employee start with report_to = '1515' connect by prior emp_code = report_to";
			BaseLogger.log("0",null,null,"getEmployeeCodes sql="+sql);
			 rs = stmt.executeQuery(sql);
			while (rs.next()) {
				
				empCodeList.add(rs.getString(1).trim());
			}
			BaseLogger.log("0",null,null,"getEmployeeCodes()="+empCodeList);
		} catch (Exception e) {

		}
		finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return empCodeList;
	}
	public List<Employee>getEmpList()
	{
		
		List<Employee> empList = new ArrayList<>();
		try {
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			String sql = "select"
					+ " emp_code,EMP_FNAME,EMP_MNAME,EMP_LNAME "
					+ "from "
					+ "employee "
					+ "start with report_to = '1515' "
					+ "connect by prior emp_code = report_to  "
					+" order by EMP_FNAME,EMP_MNAME,EMP_LNAME";
			BaseLogger.log("0",null,null,"getEmpList() sql="+sql);
			 rs = stmt.executeQuery(sql);
			while (rs.next()) {
				Employee emp = new Employee();
				emp.setEmpcode(rs.getString(1).trim());
				
				emp.setName(rs.getNString(2).trim()+" "+rs.getString(3).trim()+" "+rs.getString(4).trim());
				empList.add(emp);
			}
			
		} catch (Exception e) {

		}
		finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return empList;
	}
	
	public List<Report> getData(List<String> empCode,String dateFrom, String dateTo,String requestid)
	{
		
		
		List<Report>list = new ArrayList<>();
		try {
		String sql;
		 conn = new DbConnection().getConnection();
		 stmt = conn.createStatement();
		//System.out.println("reqiest id===>"+requestid.isEmpty());
		if(requestid.isEmpty()) {
			 sql ="select "
					+ "FBD.REQ_ID,"
					+ "SR.DTL_DESCR,"
					+ "E.EMP_FNAME || ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' "
					+ "as "
					+ "name,"
					+ "FB.EMP_CODE,"
					+ " TO_CHAR(FB.EXECUT_DT,'DD-MON-YYYY'),srad.ACTION_DETL,sra.STDTIME, TO_CHAR(srad.PLANSTDATE,'DD-MM-YYYY'),FBD.TIME_SPENT,FBD.ACTION_STATUS  "
					+ "from SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra "
					+ "where "
					+ "FB.FEEDBK_ID = FBD.FEEDBK_ID "
					+" AND "
					+ "srad.ACTION_ID = FBD.ACTION_ID "
					+ "AND"
					+ " srad.EMP_CODE  = FB.EMP_CODE "
					+ "AND "
					+ "FBD.REQ_ID = SR.REQ_ID AND FB.EMP_CODE in ('"+String.join("','", empCode).trim()+"') "
					+ "AND "
					+ "FB.EXECUT_DT between "
					+ "TO_DATE('"+dateFrom+"','yyyy/mm/dd') "
					+ "AND "
					+ "TO_DATE('"+dateTo+"','yyyy/mm/dd') "
					+ "AND "
					+ "FB.EMP_CODE = E.EMP_CODE "
					+ "group by "
					+ "FB.EMP_CODE, FBD.REQ_ID,FBD.ACTION_ID,E.EMP_FNAME ||' '||E.EMP_LNAME || '('|| trim(FB.EMP_CODE) ||')', FB.EMP_CODE,FB.EXECUT_DT,SR.DTL_DESCR,srad.ACTION_DETL,sra.STDTIME,srad.PLANSTDATE,FBD.TIME_SPENT,FBD.ACTION_STATUS  "
					+ "order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR";
		}
		else {
			sql ="select "
					+ "FBD.REQ_ID,"
					+ "SR.DTL_DESCR,"
					+ "E.EMP_FNAME || ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' "
					+ "as "
					+ "name,"
					+ "FB.EMP_CODE,"
					+ " TO_CHAR(FB.EXECUT_DT,'DD-MON-YYYY'),srad.ACTION_DETL,sra.STDTIME, TO_CHAR(srad.PLANSTDATE,'DD-MM-YYYY'),FBD.TIME_SPENT,FBD.ACTION_STATUS  "
					+ "from SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra "
					+ "where "
					+ "FB.FEEDBK_ID = FBD.FEEDBK_ID "
					+" AND "
					+ "srad.ACTION_ID = FBD.ACTION_ID "
					+ "AND"
					+ " srad.EMP_CODE  = FB.EMP_CODE "
					+ "AND "
					+ "FBD.REQ_ID = SR.REQ_ID "
					+ "AND FB.EMP_CODE in ('"+String.join("','", empCode).trim()+"') "
					+ "AND "
					+ "FB.EXECUT_DT between "
					+ "TO_DATE('"+dateFrom+"','yyyy/mm/dd') "
					+ "AND "
					+ "TO_DATE('"+dateTo+"','yyyy/mm/dd') "
					+ "AND "
					+ "FB.EMP_CODE = E.EMP_CODE "
					+" AND "
					+"FBD.REQ_ID='"+requestid+"'"
					+ "group by "
					+ "FB.EMP_CODE, FBD.REQ_ID,FBD.ACTION_ID,E.EMP_FNAME ||' '||E.EMP_LNAME || '('|| trim(FB.EMP_CODE) ||')', FB.EMP_CODE,FB.EXECUT_DT,SR.DTL_DESCR,srad.ACTION_DETL,sra.STDTIME,srad.PLANSTDATE,FBD.TIME_SPENT,FBD.ACTION_STATUS  "
					+ "order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR";
		}
		BaseLogger.log("0",null,null,"getData sql="+sql);
		 rs = stmt.executeQuery(sql);
		Report report = null;
		while (rs.next()) {
			report = new Report();
			report.setPerson(rs.getString(3));
			report.setRequestId(rs.getString(1));
			report.setDescription(rs.getString(2));
			report.setDate(rs.getString(5).toString());
			report.setActiondtl(rs.getString(6));
			report.setStdtime(rs.getInt(7));
			report.setStartdate(rs.getString(8).toString());
			report.setTimespend(rs.getInt(9));
			report.setStatus(rs.getString(10));
			list.add(report);
			
		}
		
		
	} catch (Exception e) {
				e.printStackTrace();
	}
		finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return list;
	}
	
	public String getEmployeeEmailid(String empcode) {
		
		String email=null;
		try {
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			String sql = "select EMAIL_ID_OFF from EMPLOYEE where EMP_CODE='"+empcode+"'";
			BaseLogger.log("0",null,null,"getEmployeeEmailid sql="+sql);
			rs = stmt.executeQuery(sql);
			while (rs.next()) {
				email = rs.getString(1);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return email;
	}
	public List<Plan>getPlanReport(List<String> empCode,String dateFrom, String dateTo,String requestid){
		
		List<Plan>list = new ArrayList<Plan>();
		try {
			String sql;
			if(requestid.isEmpty()) {
				
				
			sql ="SELECT"
					+ " D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' as NAME,  "
					+ "TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY'), "
					+ " A.REQ_ID, "
					+ "C.DTL_DESCR, "
					+" A.STDTIME,"
					+" B.ACTION_DETL,"
					+ "B.ACTION_ID "
					+ "FROM "
					+ "SER_REQ_ACT A, SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D "
					+ "WHERE "
					+ "A.ACTION_ID = B.ACTION_ID  "
					+ "AND "
					+ "A.REQ_ID = C.REQ_ID "
					+ "AND "
					+ "B.PLANSTDATE BETWEEN TO_DATE('"+dateFrom+"','yyyy/mm/dd') AND TO_DATE('"+dateTo+"','yyyy/mm/dd') "
					+" AND "
					+ "B.EMP_CODE  = D.EMP_CODE "
					+ "AND "
					+ "B.EMP_CODE in('"+String.join("','", empCode).trim()+"') "	
					+ "ORDER BY D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' ASC,B.PLANSTDATE,A.REQ_ID,C.DTL_DESCR,B.STDTIME,B.ACTION_DETL";
			
			sql = "SELECT "
					+ "D.EMP_FNAME || ' ' || D.EMP_LNAME ||'('||trim(B.EMP_CODE)||')' AS name,"
					+ "TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY'), "
					+ "A.REQ_ID, "
					+ "C.DTL_DESCR, "
					+ "B.STDTIME, "
					+ "B.ACTION_DETL "
					+ "FROM SER_REQ_ACT A, SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D "
					+ "WHERE "
					+ "A.ACTION_ID = B.ACTION_ID "
					+ "AND "
					+ "A.REQ_ID = C.REQ_ID "
					+ "AND "
					+ "B.PLANSTDATE BETWEEN TO_DATE('"+dateFrom+"','yyyy/mm/dd') AND TO_DATE('"+dateTo+"','yyyy/mm/dd') "
					+ "AND "
					+ "B.EMP_CODE = D.EMP_CODE "
					+ "AND "
					+ "B.EMP_CODE in('"+String.join("','", empCode).trim()+"') "
					//+ "AND "
					//+ "A.REQ_ID ='W21IPRO007' "
					+ "ORDER BY D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' ASC,B.PLANSTDATE,A.REQ_ID ";
			
			}else
			{			
						
			sql = "SELECT "
					+ "D.EMP_FNAME || ' ' || D.EMP_LNAME ||'('||trim(B.EMP_CODE)||')' AS name,"
					+ "TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY'), "
					+ "A.REQ_ID, "
					+ "C.DTL_DESCR, "
					+ "B.STDTIME, "
					+ "B.ACTION_DETL "
					+ "FROM SER_REQ_ACT A, SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D "
					+ "WHERE "
					+ "A.ACTION_ID = B.ACTION_ID "
					+ "AND "
					+ "A.REQ_ID = C.REQ_ID "
					+ "AND "
					+ "B.PLANSTDATE BETWEEN TO_DATE('"+dateFrom+"','yyyy/mm/dd') AND TO_DATE('"+dateTo+"','yyyy/mm/dd') "
					+ "AND "
					+ "B.EMP_CODE = D.EMP_CODE "
					+ "AND "
					+ "B.EMP_CODE in('"+String.join("','", empCode).trim()+"') "
					+ "AND "
					+ "A.REQ_ID ='"+requestid+"' "
					+ "ORDER BY D.EMP_FNAME || ' ' ||D.EMP_LNAME || '('||trim(B.EMP_CODE)||')' ASC,B.PLANSTDATE,A.REQ_ID ";

			
			}
			BaseLogger.log("0",null,null,"getPlanReport sql="+sql);
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			 rs = stmt.executeQuery(sql);
			while(rs.next()) {
				Plan plan = new Plan();
				plan.setActiondtl(rs.getString(6));
				plan.setDate(rs.getString(2));
				plan.setDescription(rs.getString(4));
				plan.setName(rs.getString(1));
				plan.setRequestid(rs.getString(3));
				plan.setTime(rs.getInt(5));
				list.add(plan);
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		
		return list;

	}

	public List<TodaysPlan>getTodysPlan(){
		
		List<TodaysPlan>list = new ArrayList<>();
		try {
		/*String sql="SELECT "
				+ "D.EMP_FNAME || ' ' || D.EMP_LNAME ||'('||trim(B.EMP_CODE)||')' AS name,"
				+ "A.REQ_ID,"
				+ "B.ACTION_DETL,"
				+ "C.DTL_DESCR,"
				+ "B.STDTIME,"
				+ "srf2.TIME_SPENT,"
				+ "TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY') "
				+ "FROM "
				+ "SER_REQ_ACT A,SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D ,SER_REQ_FEEDBK srf ,SER_REQ_FEEDBKDTL srf2 "
				+ "WHERE "
				+ "A.ACTION_ID = B.ACTION_ID "
				+ "AND A.REQ_ID = C.REQ_ID "
				+ "AND B.PLANSTDATE = TO_DATE('2022/03/14','yyyy/mm/dd') "
				+ "AND B.EMP_CODE = D.EMP_CODE "
				+ "AND srf.FEEDBK_ID  = srf2.FEEDBK_ID "
				+ "AND srf2.ACTION_ID  = A.ACTION_ID "
				+ "ORDER BY name ASC ,B.PLANSTDATE,A.REQ_ID";*/
			Date currentDate = new Date();
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
			String currentDateString = dateFormat.format(currentDate);
			BaseLogger.log("0",null,null,"getTodysPlan dsate="+currentDateString);
		String sql = "SELECT "
				+ "D.EMP_FNAME || ' ' || D.EMP_LNAME ||'('||trim(B.EMP_CODE)||')' AS name,"
				+ "A.REQ_ID,"
				+ "B.ACTION_DETL,"
				+ "C.DTL_DESCR,"
				+ "B.STDTIME,"
				+ "srf2.TIME_SPENT,"
				+ "TO_CHAR(B.PLANSTDATE,'DD-MON-YYYY') "
				+ "FROM "
				+ "SER_REQ_ACT A,SER_REQ_ACT_DETL B, SER_REQUEST C, EMPLOYEE D ,SER_REQ_FEEDBK srf ,SER_REQ_FEEDBKDTL srf2 "
				+ "WHERE "
				+ "A.ACTION_ID = B.ACTION_ID "
				+ "AND A.REQ_ID = C.REQ_ID "
				+ "AND B.PLANSTDATE = TO_DATE('" + currentDateString + "','yyyy/MM/dd') "
				+ "AND B.EMP_CODE = D.EMP_CODE "
				+ "AND srf.FEEDBK_ID  = srf2.FEEDBK_ID "
				+ "AND srf2.ACTION_ID  = A.ACTION_ID "
				+ "ORDER BY name ASC ,B.PLANSTDATE,A.REQ_ID";
		 conn = new DbConnection().getConnection();
		 stmt = conn.createStatement();
		BaseLogger.log("0",null,null,"getTodysPlan sql="+sql);
		rs = stmt.executeQuery(sql);
		while(rs.next()) {
			TodaysPlan plan = new TodaysPlan();
			plan.setName(rs.getString(1));
			plan.setRequestid(rs.getString(2));
			plan.setActiondtl(rs.getString(3));
			plan.setDescription(rs.getString(4));
			plan.setTime(rs.getInt(5));
			plan.setSpentTime(rs.getInt(6));
			plan.setDate(rs.getString(7));
			list.add(plan);
		}
		
		}catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return list;
	}
	public List<Report>getYesterdayFeedback(){
		
		List<Report>list = new ArrayList<Report>();
		try {
			String sql="select "
					+ "FBD.REQ_ID,"
					+ "SR.DTL_DESCR,"
					+ "FBD.ACTION_DETLS,"
					+ "E.EMP_FNAME || ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' as name,"
					+ "FB.EMP_CODE,"
					+ "TO_CHAR(FB.EXECUT_DT,'DD-MON-YYYY'),"
					+ "srad.ACTION_DETL,"
					+ "sra.STDTIME,"
					+ "TO_CHAR(srad.PLANSTDATE,'DD-MM-YYYY'),"
					+ "FBD.TIME_SPENT,"
					+ "TO_CHAR(FB.FEEDBK_DT ,'DD-MM-YYYY')"
					+ "from "
					+ "SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra "
					+ "where "
					+ "FB.FEEDBK_ID = FBD.FEEDBK_ID "
					+ "AND "
					+ "srad.ACTION_ID = FBD.ACTION_ID "
					+ "AND "
					+ "srad.EMP_CODE  = FB.EMP_CODE "
					+ "AND "
					+ "FBD.REQ_ID = SR.REQ_ID "
					+ "AND "
					+ "FB .FEEDBK_DT ='22-03-2022' "//CURRENT_DATE"
					+ "AND "
					+ "FB.EMP_CODE = E.EMP_CODE "
					+ "group by FB.EMP_CODE, FBD.REQ_ID,FBD.ACTION_ID,E.EMP_FNAME ||' '||E.EMP_LNAME || '('|| trim(FB.EMP_CODE) ||')',FB.EMP_CODE,FB.EXECUT_DT,SR.DTL_DESCR,srad.ACTION_DETL,sra.STDTIME,srad.PLANSTDATE,FBD.TIME_SPENT,FBD.ACTION_DETLS ,FB.FEEDBK_DT "
					+ "order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR";
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			BaseLogger.log("0",null,null,"getYesterdayFeedback sql="+sql);
			 rs = stmt.executeQuery(sql);
			Report report = null;
			while (rs.next()) {
				report = new Report();
				report.setRequestId(rs.getString(1));
				report.setDescription(rs.getString(2));
				report.setActiondtl(rs.getString(3));
				report.setPerson(rs.getString(4));
				report.setDate(rs.getString(11));
				report.setStdtime(rs.getInt(8));
				report.setStartdate(rs.getString(9));
				report.setTimespend(rs.getInt(10));
				list.add(report);
				
			}
			//System.out.println(sql);
		} catch (Exception e) {
			e.printStackTrace();
			
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return list;
	}
	public List<Report>getYesterdayFeedback2(){
		
		List<Report>list = new ArrayList<Report>();
		try {
			String sql = "select "
					+ "E.EMP_FNAME ||' '||E.EMP_MNAME||  ' ' ||E.EMP_LNAME || '('||trim(FB.EMP_CODE)||')' as name,"
					+ "FBD.REQ_ID,"
					+ "SR.DTL_DESCR,"
					+ "FBD.ACTION_DETLS,"
					+ "FBD.TIME_SPENT,"
					+ "srad.STDTIME,"
					+ "FBD.ACTION_STATUS "
					+ "FROM "
					+ "SER_REQ_FEEDBK FB, SER_REQ_FEEDBKDTL FBD,EMPLOYEE E,SER_REQUEST SR,SER_REQ_ACT_DETL srad,SER_REQ_ACT sra "
					+ "where "
					+ "FB.FEEDBK_ID = FBD.FEEDBK_ID "
					+ "AND "
					+ "srad.ACTION_ID = FBD.ACTION_ID "
					+ "AND "
					+ "srad.EMP_CODE  = FB.EMP_CODE "
					+ "AND "
					+ "FBD.REQ_ID = SR.REQ_ID "
					+ "AND "
					+ "sra.ACTION_ID  = srad.ACTION_ID "
					+ "AND "
					+ "FB.EXECUT_DT =TO_DATE('2022/04/05','yyyy/mm/dd') "
					+ "AND "
					+ "FB.EMP_CODE = E.EMP_CODE "
					+ "order by name ASC,FB.EXECUT_DT ASC,FBD.REQ_ID,SR.DTL_DESCR";
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			BaseLogger.log("0",null,null,"getYesterdayFeedback2 sql="+sql);
			 rs = stmt.executeQuery(sql);
			while (rs.next()) {
				Report report = new Report();
				report.setPerson(rs.getString(1));
				report.setRequestId(rs.getString(2));
				report.setActiondtl(rs.getString(3));
				report.setDescription(rs.getString(4));
				report.setTimespend(rs.getInt(5));
				report.setStdtime(rs.getInt(6));
				report.setStatus(rs.getString(7));
				list.add(report);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return list;
	}
	public String getCurrentStatus(String requestid) {
		
		String status="";
		try {
			String sql="SELECT srf.ACTION_STATUS FROM SER_REQ_FEEDBKDTL srf ,SER_REQ_FEEDBK srf2 "
					+ "WHERE "
					+ "srf2.FEEDBK_ID =srf.FEEDBK_ID "
					+ "AND "
					+ "srf.REQ_ID ='"+requestid+"'"
					+ "AND "
					+ "srf2.FEEDBK_DT  = "
					+ "(SELECT MAx(srf2.FEEDBK_DT)FROM SER_REQ_FEEDBKDTL srf ,SER_REQ_FEEDBK srf2 "
					+ "WHERE "
					+ "srf2.FEEDBK_ID =srf.FEEDBK_ID "
					+ "AND "
					+ "srf.REQ_ID ='"+requestid+"')";
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			BaseLogger.log("0",null,null,"getCurrentStatus sql="+sql);
			 rs = stmt.executeQuery(sql);
			if(rs.next())			
			status = rs.getString(1);
		} catch (Exception e) {
		e.printStackTrace();
		
		}
		finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return status;
	}
	public Map<String,List<String>> getEmployeeRequestId(LocalDate start,LocalDate end,List<String> empCode) {
		
		try {
			String sql="SELECT "
						+ "DISTINCT srf.REQ_ID ,TO_CHAR(srf.EXECUT_DT,'DD-MON-YYYY'),E.EMP_FNAME || ' ' ||E.EMP_LNAME  as name "
						+ "FROM SER_REQ_FEEDBK srf,EMPLOYEE e "
						+ "WHERE "
						+ "e.EMP_CODE  = srf.EMP_CODE "
						+ "AND "
						+ "srf.EMP_CODE in ('"+String.join("','", empCode).trim()+"') "
						+ "AND "
						+ "srf.EXECUT_DT between TO_DATE('"+start+"','yyyy/mm/dd') AND TO_DATE('"+end+"','yyyy/mm/dd') "
						+ "GROUP BY srf.REQ_ID ,srf.EXECUT_DT,E.EMP_FNAME || ' ' ||E.EMP_LNAME ";
			
			BaseLogger.log("0",null,null,"getEmployeeRequestId() sql="+sql);
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			 rs = stmt.executeQuery(sql);
			Map<String,List<String>> map = new HashMap<String, List<String>>();
			while (rs.next()) {
				//System.out.println(rs.getString(1)+rs.getString(3));
				if(empCode.size()>1) {
					map =addInMap(rs.getString(2), rs.getString(1)+" "+rs.getString(3), map);
				}else {
					map =addInMap(rs.getString(2), rs.getString(1), map);
				}
			}
			return map;
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return null;
	}
	Map<String,List<String>> addInMap(String date,String reqid,Map<String,List<String>>map) {
		if(map.isEmpty()) {
			List<String>list = new ArrayList<String>();
			list.add(reqid);
			map.put(date,list);
		}
		else {
			if(map.get(date)==null) {
				List<String>list = new ArrayList<String>();
				list.add(reqid);
				map.put(date, list);
			}
			else {
				map.get(date).add(reqid);
			}
		}
		return map;
	}
	public Map<String,List<FeedbackCalendar>> getFeedbackCalendar(LocalDate start,LocalDate end,List<String>empCode) {
		
		Map<String,List<FeedbackCalendar>> map = new HashMap<>();
		try {
			String sql="SELECT "
					+ "srf.REQ_ID,TO_CHAR(srf.EXECUT_DT,'DD-MON-YYYY'),E.EMP_FNAME || ' ' ||E.EMP_LNAME as name,"
					+ "sra.STDTIME ,srf2.TIME_SPENT,srf.EMP_CODE,sra.ACTION_ID  "
					+ "FROM SER_REQ_FEEDBK srf,SER_REQ_FEEDBKDTL srf2 ,EMPLOYEE e ,SER_REQ_ACT sra "
					+ "WHERE "
					+ "e.EMP_CODE  = srf.EMP_CODE "
					+ "AND "
					+ "sra.REQ_ID  = srf.REQ_ID "
					+ "AND "
					+ "SRF .FEEDBK_ID  = srf2.FEEDBK_ID "
					+ "AND "
					+ "srf2.ACTION_ID  = sra.ACTION_ID "
					+ "AND "
					+ "srf.EMP_CODE in ('"+String.join("','", empCode).trim()+"') "
					+ "AND "
					+ "srf.EXECUT_DT between TO_DATE('"+start+"','yyyy/mm/dd') AND TO_DATE('"+end+"','yyyy/mm/dd') "
					+ "GROUP BY srf.REQ_ID ,srf.EXECUT_DT,E.EMP_FNAME || ' ' ||E.EMP_LNAME ,sra.STDTIME,srf2.TIME_SPENT,srf.EMP_CODE,sra.ACTION_ID  "
					+ "ORDER BY srf.EXECUT_DT,E.EMP_FNAME || ' ' ||E.EMP_LNAME";
			BaseLogger.log("0",null,null,"getFeedbackCalendar() sql="+sql);
			Connection conn = new DbConnection().getConnection();
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(sql);
			
			while (rs.next()) {
				FeedbackCalendar cal = new FeedbackCalendar();
				cal.setRequestid(rs.getString(1));
				cal.setDate(rs.getString(2));
				cal.setTime(rs.getInt(4));
				cal.setSpenttime(rs.getInt(5));
				cal.setTotalspent(getTotalTimeSpent(rs.getString(1), rs.getString(6),rs.getString(7)));
				cal.setActionid(rs.getString(7));
				if(empCode.size()>1)//multiple employee selected
				{
					cal.setEmpname(rs.getString(3));
				}
				else {//one employee selected
					cal.setEmpname("");
				}
				BaseLogger.log("0",null,null,"getFeedbackCalendar() cal="+cal);
				map = getFeedbackCalendarMap(cal, cal.getDate(), map);
			}
			BaseLogger.log("0",null,null,"getFeedbackCalendar() map size="+map.size());
			conn.close();
			return map;
		} catch (Exception e) {
			BaseLogger.log("0",null,null,"getFeedbackCalendar() Error="+e.getMessage());
			e.printStackTrace();
			return null;
		}
		//return map;
	}
	Map<String,List<FeedbackCalendar>>getFeedbackCalendarMap(FeedbackCalendar cal,String date,Map<String,List<FeedbackCalendar>>map){
		if(map.isEmpty()) {//adding first
			List<FeedbackCalendar>list = new ArrayList<FeedbackCalendar>();
			list.add(cal);
			map.put(date, list);
		}
		else {
			if(map.get(date)==null) {
				List<FeedbackCalendar>list = new ArrayList<FeedbackCalendar>();
				list.add(cal);
				map.put(date, list);
			}
			else {
				map.get(date).add(cal);
			}
		}
		return map;
	}
	int getTotalTimeSpent(String requestid,String empcode,String actionid) {
		
		int totaltime=0;
		try {
			String sql="SELECT sum(srf.TIME_SPENT) "
					+ "FROM SER_REQ_FEEDBKDTL srf,SER_REQ_FEEDBK srf2,SER_REQ_ACT sra ,SER_REQ_ACT_DETL srad "
					+ "WHERE "
					+ "srf.FEEDBK_ID =srf2.FEEDBK_ID "
					+ "AND "
					+ "sra.ACTION_ID  = srad.ACTION_ID "
					+ "AND "
					+ "srf.ACTION_ID  = srad.ACTION_ID "
					+ "AND "
					+ "srf2.EMP_CODE ='"+empcode+"'"
					+ "AND "
					+ "srf.REQ_ID ='"+requestid+"'"
					+ "AND "
					+ "srf.ACTION_ID ='"+actionid+"'";
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			BaseLogger.log("0",null,null,"getTotalTimeSpent sql="+sql);
			 rs = stmt.executeQuery(sql);
			//Map<String,List<FeedbackCalendar>> map = new HashMap<>();
			rs.next();
			totaltime= rs.getInt(1);
			conn.close();
			
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return totaltime;
	}
	public Map<String,List<Plan>> getPlanCalendar(LocalDate start,LocalDate end,List<String> empcode) {
		
		Map<String,List<Plan>> map = new HashMap<>();
		try {
			String sql="SELECT "
					+ "e.EMP_FNAME || ' '||e.EMP_LNAME  AS name,"
					+ "TO_CHAR(srad.PLANSTDATE,'DD-MON-YYYY'),"
					+ "sra.REQ_ID,"
					+ "srad.STDTIME "
					+ "FROM EMPLOYEE e,SER_REQ_ACT sra  ,SER_REQ_ACT_DETL srad ,SER_REQUEST sr "
					+ "WHERE "
					+ "sra.ACTION_ID=srad.ACTION_ID "
					+ "AND "
					+ "sra.REQ_ID=sr.REQ_ID "
					+ "AND "
					+ "e.EMP_CODE=srad.EMP_CODE "
					+ "AND "
					+ "srad.PLANSTDATE BETWEEN TO_DATE('"+start+"','yyyy/mm/dd') AND TO_DATE('"+end+"','yyyy/mm/dd') "
					+ "AND "
					+ "srad.EMP_CODE in ('"+String.join("','", empcode).trim()+"') "
					+ "GROUP BY e.EMP_FNAME || ' '||e.EMP_LNAME,srad.PLANSTDATE,sra.REQ_ID,srad.STDTIME "
					+ "ORDER BY srad.PLANSTDATE ASC";
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			BaseLogger.log("0",null,null,"getPlanCalendar sql="+sql);
			 rs = stmt.executeQuery(sql);
			
			while (rs.next()) {
				Plan plan = new Plan();
				if(empcode.size()>1)
				plan.setName(rs.getString(1));
				else
					plan.setName("");
				plan.setDate(rs.getString(2));
				plan.setRequestid(rs.getString(3));
				plan.setTime(rs.getInt(4));
				map = addPlanMap(plan,map);
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return map;
	}
	Map<String,List<Plan>> addPlanMap(Plan plan,Map<String,List<Plan>>map) {
		if(map.isEmpty()) {
			List<Plan>list = new ArrayList<>();
			list.add(plan);
			map.put(plan.getDate(),list);
		}
		else {
			if(map.get(plan.getDate())==null) {
				List<Plan>list = new ArrayList<>();
				list.add(plan);
				map.put(plan.getDate(),list);
			}
			else {
				map.get(plan.getDate()).add(plan);
			}
		}
		return map;
	}
	public List<Holiday> getHoliday() {
		List<Holiday>list = new ArrayList<Holiday>();
		try {
			
			String sql = "SELECT H.ID,H.START_DATE ,H.END_DATE ,H.HOLIDAY_DESC  FROM HOLIDAY H";
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			BaseLogger.log("0",null,null,"getHoliday sql="+sql);
			 rs = stmt.executeQuery(sql);
			while(rs.next()) {
				Holiday holiday = new Holiday();
				holiday.setId(rs.getInt(1));
				holiday.setStart(rs.getDate(2).toLocalDate());
				holiday.setEnd(rs.getDate(3).toLocalDate());
				holiday.setDescription(rs.getString(4));
				list.add(holiday);
			}
			conn.close();
			return list;
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return list;
	}
	public List<Holiday> getHoliday(String start,String end) {
		List<Holiday>list = new ArrayList<Holiday>();
		try {
			
			String sql = "SELECT "
					+ "h.ID,h.START_DATE ,h.END_DATE ,h.HOLIDAY_DESC "
					+ "FROM "
					+ "HOLIDAY h "
					+ "WHERE "
					+ "h.START_DATE  between TO_DATE('"+start+"','DD-MM-YYYY') AND TO_DATE('"+end+"','DD-MM-YYYY')";
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			 rs = stmt.executeQuery(sql);
			while(rs.next()) {
				Holiday holiday = new Holiday();
				holiday.setId(rs.getInt(1));
				holiday.setStart(rs.getDate(2).toLocalDate());
				holiday.setEnd(rs.getDate(3).toLocalDate());
				holiday.setDescription(rs.getString(4));
				list.add(holiday);
			}
			conn.close();
			return list;
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return list;
	}
	public List<Leave> getLeave(String empcode,String start,String end) {
		List<Leave>list = new ArrayList<>();
		try {
			
			String sql = "SELECT "
					+ "l.ID,"
					+ "l.START_DATE,"
					+ "l.END_DATE,"
					+ "l.EMP_CODE "
					+ "FROM LEAVE l "
					+ "WHERE "
					+ "l.EMP_CODE ='"+empcode+"'"
					+ "AND "
					+ "l.START_DATE  between TO_DATE('"+start+"','DD-MM-YYYY') AND TO_DATE('"+end+"','DD-MM-YYYY')";
			BaseLogger.log("0",null,null,"getLeave sql="+sql);
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			 rs = stmt.executeQuery(sql);
			while(rs.next()) {
				Leave leave = new Leave();
				leave.setId(rs.getInt(1));
				leave.setStartdate(rs.getDate(2).toLocalDate());
				leave.setEnddate(rs.getDate(3).toLocalDate());
				leave.setEmpcode(rs.getString(4));
				list.add(leave);
				//System.out.println("From Dao="+leave);
			}
			conn.close();
			return list;
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return list;
	}
	public List<Leave> getLeave(String empcode) {
		List<Leave>list = new ArrayList<>();
		try {
			
			String sql = "SELECT l.id,l.START_DATE ,l.END_DATE ,l.EMP_CODE FROM LEAVE l WHERE l.EMP_CODE ='"+empcode+"'";
			BaseLogger.log("0",null,null,"getLeave() sql="+sql);
			 conn = new DbConnection().getConnection();
			 stmt = conn.createStatement();
			 rs = stmt.executeQuery(sql);
			while(rs.next()) {
				Leave leave = new Leave();
				leave.setId(rs.getInt(1));
				leave.setStartdate(rs.getDate(2).toLocalDate());
				leave.setEnddate(rs.getDate(3).toLocalDate());
				leave.setEmpcode(rs.getString(4));
				list.add(leave);
				//System.out.println("From Dao="+leave);
			}
			conn.close();
			return list;
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
		    if (rs != null) {
		        try {
		            rs.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (stmt != null) {
		        try {
		        	stmt.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		    if (conn != null) {
		        try {
		            conn.close();
		        } catch (SQLException e) { /* Ignored */}
		    }
		}
		return list;
	}
}
